
#ifndef USE_VERTEXALPHAHIDING
		SPECIALISATION_PARAM( useVertexAlphaHiding, "Use vertex alpha hiding?", "USE_VERTEXALPHAHIDING" )	// TRUE if the environment map is to be used	
#else
		static const bool useVertexAlphaHiding = true;
#endif


float4 PerformVertexAlphaHiding( float4 projectedVertexPos, float vertexAlpha, float alphaThreshold0, float alphaThreshold1 )
{
	DEPENDENT_CODE_START( useVertexAlphaHiding )
#if defined( _3DSMAX_ ) || defined( USE_VERTEXALPHAHIDING )
	if( vertexAlpha > alphaThreshold0 && vertexAlpha < alphaThreshold1 )
	{
		// this will clip the vertex away
		return float4(0,0,1,0);		
	}
	else
	{
		return projectedVertexPos;
	}
#endif
	DEPENDENT_CODE_ELSE( useVertexAlphaHiding )	
#if defined( _3DSMAX_ ) || !defined( USE_VERTEXALPHAHIDING )
		return projectedVertexPos;
#endif
	DEPENDENT_CODE_END( useVertexAlphaHiding )	
}

float4 PerformVertexAlphaHiding( float4 projectedVertexPos, float4 vertexColour, float alphaThreshold0, float alphaThreshold1 )
{
	return PerformVertexAlphaHiding( projectedVertexPos, vertexColour.a, alphaThreshold0, alphaThreshold1 );
}
